clc; clear; 

%% Problem Data
n = 2;

Q = [0.3   -0.7
    -0.7    2.0];

h  = [-1; .1];

x0 = [-1; 1];

center = [1;3];
radius = 3;



%% Algorithm


alpha_start = 1/max(eig(Q));
% alpha_start = 3; 


% Projected grad descent fix
[x_pgd,data,k] = PGD_circle_fix(@(x)(objective(x,Q,h)),Q,h,center,radius,x0,alpha_start);

% Projected grad descent decreasing
% [x_pgd,data,k] = PGD_circle_decr(@(x)(objective(x,Q,h)),Q,h,center,radius,x0,alpha_start);


% Projected grad descent arm
% beta = 0.5;
% [x_pgd,data,k] = PGD_circle_arm(@(x)(objective(x,Q,h)),Q,h,center,radius,x0,beta,alpha_start);

fprintf('Solution found by PGD\n')
disp(x_pgd)
fprintf('Function value %.4e \n',0.5*x_pgd'*Q*x_pgd + h'*x_pgd)

% solve the GAP problem
options = optimoptions('linprog','OptimalityTolerance',1e-8,'Display','off');

GAP = ones(k,1);
for i = 1:k
    
    GAP(i)=norm(project_circle(data.x(:,i)-Q*data.x(:,i)-h,center,radius)-data.x(:,i));

end
fprintf('Final GAP value %.4e \n',GAP(end));


%% Plotting total

% Plot the QP
figure(1),clf, hold on, box on
title('Full iterates')
axis equal
% plot the feasible region
pos = [(center(1)-radius) (center(2)-radius) 2*radius 2*radius]; 
rectangle('Position',pos,'Curvature',[1 1],'FaceColor',[0.8,0.8,0.8]);
obj = @(x,y) 0.5.*x.*Q(1,1).*x + 0.5.*y.*Q(2,2).*y + x.*Q(1,2).*y + x.*h(1)+y.*h(2);
fcontour(obj,'--','LineWidth',2)
% Plot computed optimum
plot(x_pgd(1),x_pgd(2,end),"hexagram",'MarkerSize',15,'MarkerFaceColor','b')

% Plot the iterates and search directions
for i = 1:k
    plot(data.x(1,i),data.x(2,i),'ko','MarkerFaceColor','k')
    plot(data.x(1,i)-data.g(1,i)*data.a(i),data.x(2,i)-data.g(2,i)*data.a(i),'ro','MarkerFaceColor','g')
    quiver(data.x(1,i),data.x(2,i),-alpha_start*data.g(1,i),-alpha_start*data.g(2,i),0,'Color','r','LineWidth',2)
    quiver(data.x(1,i),data.x(2,i),-data.g(1,i),-data.g(2,i),0,'Color','green','LineWidth',2)
    if i<k
        quiver(data.x(1,i)-data.g(1,i)*data.a(i),data.x(2,i)-data.g(2,i)*data.a(i),....
    data.x(1,i+1)-(data.x(1,i)-data.g(1,i)*data.a(i)),data.x(2,i+1)-...
    (data.x(2,i)-data.g(2,i)*data.a(i)),0,'Color','k','LineWidth',2)
        plot(data.x(1,i+1),data.x(2,i+1),'ko','MarkerFaceColor','k')
    end
%     pause
end



%% Plot first iterates

% Plot possible stepsizes for x0


figure(2),clf, hold on, box on
title('First iteration')
axis equal
pos = [(center(1)-radius) (center(2)-radius) 2*radius 2*radius]; 
rectangle('Position',pos,'Curvature',[1 1],'FaceColor',[0.8,0.8,0.8]);
obj = @(x,y) 0.5.*x.*Q(1,1).*x + 0.5.*y.*Q(2,2).*y + x.*Q(1,2).*y + x.*h(1)+y.*h(2);
fcontour(obj,'--','LineWidth',2)
plot(x_pgd(1),x_pgd(2,end),"hexagram",'MarkerSize',15,'MarkerFaceColor','b')

x0 = project_circle(x0,center,radius);
plot(x0(1),x0(2),'ko','MarkerFaceColor','r','MarkerSize',6)

alpha_k = alpha_start;
gradient = x0 - alpha_k*(Q*x0 + h);
quiver(x0(1),x0(2),gradient(1)-x0(1),gradient(2)-x0(2),0,'Color','g','LineWidth',2)

for i = 1:10
    xk= x0 - alpha_k*(Q*x0 + h);
    xk1 = project_circle(xk ,center,radius);
    
    plot(xk(1),xk(2),'ko','MarkerFaceColor','g','MarkerSize',6)
    plot(xk1(1),xk1(2),'ko','MarkerFaceColor','k','MarkerSize',6)

    quiver(xk(1),xk(2),xk1(1)-xk(1),xk1(2)-xk(2),0,'Color','k','LineWidth',2)

    alpha_k = alpha_k*beta;
end
% 
% 
% % Plot possible stepsizes for x1
% 
% 
% figure(3),clf, hold on, box on
% title('Second iteration')
% axis equal
% pos = [(center(1)-radius) (center(2)-radius) 2*radius 2*radius]; 
% rectangle('Position',pos,'Curvature',[1 1],'FaceColor',[0.8,0.8,0.8]);
% obj = @(x,y) 0.5.*x.*Q(1,1).*x + 0.5.*y.*Q(2,2).*y + x.*Q(1,2).*y + x.*h(1)+y.*h(2);
% fcontour(obj,'--','LineWidth',2)
% plot(x_pgd(1),x_pgd(2,end),"hexagram",'MarkerSize',15,'MarkerFaceColor','b')
% 
% 
% x0 = project_circle(data.x(:,2),center,radius);
% plot(x0(1),x0(2),'ko','MarkerFaceColor','r','MarkerSize',6)
% 
% alpha_k = alpha_start;
% gradient = x0 - alpha_k*(Q*x0 + h);
% quiver(x0(1),x0(2),gradient(1)-x0(1),gradient(2)-x0(2),0,'Color','g','LineWidth',2)
% 
% for j = 1:10
% 
%     xk= x0 - alpha_k*(Q*x0 + h);
%     xk1 = project_circle(xk ,center,radius);
%     
%     plot(xk(1),xk(2),'ko','MarkerFaceColor','g','MarkerSize',6)
%     plot(xk1(1),xk1(2),'ko','MarkerFaceColor','k','MarkerSize',6)
% 
%     quiver(xk(1),xk(2),xk1(1)-xk(1),xk1(2)-xk(2),0,'Color','k','LineWidth',2)
% 
%     alpha_k = alpha_k*beta;
% end












